/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise.transaction.log.checkpoint;

import org.neo4j.kernel.impl.transaction.log.checkpoint.AbstractCheckPointThreshold;

class ContinuousCheckPointThreshold
extends AbstractCheckPointThreshold {
    private volatile long nextTransactionIdTarget;

    ContinuousCheckPointThreshold() {
        super("continuous threshold");
    }

    protected boolean thresholdReached(long lastCommittedTransactionId) {
        return lastCommittedTransactionId >= this.nextTransactionIdTarget;
    }

    public void initialize(long transactionId) {
        this.checkPointHappened(transactionId);
    }

    public void checkPointHappened(long transactionId) {
        this.nextTransactionIdTarget = transactionId + 1L;
    }

    public long checkFrequencyMillis() {
        return 100L;
    }
}

