/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.net;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.api.net.NetworkConnectionIdGenerator;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;

public class DefaultNetworkConnectionTracker
implements NetworkConnectionTracker {
    private final NetworkConnectionIdGenerator idGenerator = new NetworkConnectionIdGenerator();
    private final Map<String, TrackedNetworkConnection> connectionsById = new ConcurrentHashMap<String, TrackedNetworkConnection>();

    public String newConnectionId(String connector) {
        return this.idGenerator.newConnectionId(connector);
    }

    public void add(TrackedNetworkConnection connection) {
        TrackedNetworkConnection previousConnection = this.connectionsById.put(connection.id(), connection);
        if (previousConnection != null) {
            throw new IllegalArgumentException("Attempt to register a connection with an existing id " + connection.id() + ". Existing connection: " + previousConnection + ", new connection: " + connection);
        }
    }

    public void remove(TrackedNetworkConnection connection) {
        this.connectionsById.remove(connection.id());
    }

    public TrackedNetworkConnection get(String id) {
        return this.connectionsById.get(id);
    }

    public List<TrackedNetworkConnection> activeConnections() {
        return new ArrayList<TrackedNetworkConnection>(this.connectionsById.values());
    }
}

