/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.PageCacheWarmer;
import org.neo4j.kernel.impl.pagecache.WarmupAvailabilityListener;
import org.neo4j.kernel.impl.pagecache.monitor.PageCacheWarmerMonitor;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.JobScheduler;

class PageCacheWarmerKernelExtension
extends LifecycleAdapter {
    private final DatabaseAvailabilityGuard databaseAvailabilityGuard;
    private final NeoStoreDataSource dataSource;
    private final Config config;
    private final PageCacheWarmer pageCacheWarmer;
    private final WarmupAvailabilityListener availabilityListener;
    private volatile boolean started;

    PageCacheWarmerKernelExtension(JobScheduler scheduler, DatabaseAvailabilityGuard databaseAvailabilityGuard, PageCache pageCache, FileSystemAbstraction fs, NeoStoreDataSource dataSource, Log log, PageCacheWarmerMonitor monitor, Config config) {
        this.databaseAvailabilityGuard = databaseAvailabilityGuard;
        this.dataSource = dataSource;
        this.config = config;
        this.pageCacheWarmer = new PageCacheWarmer(fs, pageCache, scheduler, dataSource.getDatabaseLayout().databaseDirectory());
        this.availabilityListener = new WarmupAvailabilityListener(scheduler, this.pageCacheWarmer, config, log, monitor);
    }

    public void start() {
        if (((Boolean)this.config.get(GraphDatabaseSettings.pagecache_warmup_enabled)).booleanValue()) {
            this.pageCacheWarmer.start();
            this.databaseAvailabilityGuard.addListener((AvailabilityListener)this.availabilityListener);
            this.getNeoStoreFileListing().registerStoreFileProvider((NeoStoreFileListing.StoreFileProvider)this.pageCacheWarmer);
            this.started = true;
        }
    }

    public void stop() throws Throwable {
        if (this.started) {
            this.databaseAvailabilityGuard.removeListener((AvailabilityListener)this.availabilityListener);
            this.availabilityListener.unavailable();
            this.pageCacheWarmer.stop();
            this.started = false;
        }
    }

    private NeoStoreFileListing getNeoStoreFileListing() {
        return (NeoStoreFileListing)this.dataSource.getDependencyResolver().resolveDependency(NeoStoreFileListing.class);
    }
}

