/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.pagecache.PageCacheWarmer;
import org.neo4j.kernel.impl.pagecache.PageCacheWarmerKernelExtension;
import org.neo4j.kernel.impl.pagecache.monitor.PageCacheWarmerLoggingMonitor;
import org.neo4j.kernel.impl.pagecache.monitor.PageCacheWarmerMonitor;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;

public class PageCacheWarmerKernelExtensionFactory
extends KernelExtensionFactory<Dependencies> {
    public PageCacheWarmerKernelExtensionFactory() {
        super(ExtensionType.DATABASE, "pagecachewarmer");
    }

    public Lifecycle newInstance(KernelContext context, Dependencies deps) {
        JobScheduler scheduler = deps.jobScheduler();
        DatabaseAvailabilityGuard databaseAvailabilityGuard = deps.availabilityGuard();
        PageCache pageCache = deps.pageCache();
        FileSystemAbstraction fs = deps.fileSystemAbstraction();
        LogService logService = deps.logService();
        NeoStoreDataSource dataSourceManager = deps.getDataSource();
        Log log = logService.getInternalLog(PageCacheWarmer.class);
        Monitors monitors = deps.monitors();
        PageCacheWarmerMonitor monitor = (PageCacheWarmerMonitor)monitors.newMonitor(PageCacheWarmerMonitor.class, new String[0]);
        monitors.addMonitorListener((Object)new PageCacheWarmerLoggingMonitor(log), new String[0]);
        Config config = deps.config();
        return new PageCacheWarmerKernelExtension(scheduler, databaseAvailabilityGuard, pageCache, fs, dataSourceManager, log, monitor, config);
    }

    public static interface Dependencies {
        public JobScheduler jobScheduler();

        public DatabaseAvailabilityGuard availabilityGuard();

        public PageCache pageCache();

        public FileSystemAbstraction fileSystemAbstraction();

        public NeoStoreDataSource getDataSource();

        public LogService logService();

        public Monitors monitors();

        public Config config();
    }
}

