/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.pagecache.PageLoader;
import org.neo4j.kernel.impl.pagecache.ParallelPageLoader;
import org.neo4j.kernel.impl.pagecache.SingleCursorPageLoader;

class PageLoaderFactory {
    private final ExecutorService executor;
    private final PageCache pageCache;

    PageLoaderFactory(ExecutorService executor, PageCache pageCache) {
        this.executor = executor;
        this.pageCache = pageCache;
    }

    PageLoader getLoader(PagedFile file) throws IOException {
        if (FileUtils.highIODevice((Path)file.file().toPath(), (boolean)false)) {
            return new ParallelPageLoader(file, this.executor, this.pageCache);
        }
        return new SingleCursorPageLoader(file);
    }
}

