/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.PageCacheWarmer;
import org.neo4j.kernel.impl.pagecache.monitor.PageCacheWarmerMonitor;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

class WarmupAvailabilityListener
implements AvailabilityListener {
    private final JobScheduler scheduler;
    private final PageCacheWarmer pageCacheWarmer;
    private final Config config;
    private final Log log;
    private final PageCacheWarmerMonitor monitor;
    private volatile boolean available;
    private JobHandle jobHandle;

    WarmupAvailabilityListener(JobScheduler scheduler, PageCacheWarmer pageCacheWarmer, Config config, Log log, PageCacheWarmerMonitor monitor) {
        this.scheduler = scheduler;
        this.pageCacheWarmer = pageCacheWarmer;
        this.config = config;
        this.log = log;
        this.monitor = monitor;
    }

    public synchronized void available() {
        this.available = true;
        this.jobHandle = this.scheduler.schedule(Group.FILE_IO_HELPER, this::startWarmup);
    }

    private void startWarmup() {
        if (!this.available) {
            return;
        }
        try {
            this.monitor.warmupStarted();
            this.pageCacheWarmer.reheat().ifPresent(this.monitor::warmupCompleted);
        }
        catch (Exception e) {
            this.log.debug("Active page cache warmup failed, so it may take longer for the cache to be populated with hot data.", (Throwable)e);
        }
        this.scheduleProfile();
    }

    private synchronized void scheduleProfile() {
        if (!this.available) {
            return;
        }
        long frequencyMillis = ((Duration)this.config.get(GraphDatabaseSettings.pagecache_warmup_profiling_interval)).toMillis();
        this.jobHandle = this.scheduler.scheduleRecurring(Group.FILE_IO_HELPER, this::doProfile, frequencyMillis, TimeUnit.MILLISECONDS);
    }

    private void doProfile() {
        try {
            this.pageCacheWarmer.profile().ifPresent(this.monitor::profileCompleted);
        }
        catch (Exception e) {
            this.log.debug("Page cache profiling failed, so no new profile of what data is hot or not was produced. This may reduce the effectiveness of a future page cache warmup process.", (Throwable)e);
        }
    }

    public synchronized void unavailable() {
        this.available = false;
        if (this.jobHandle != null) {
            this.jobHandle.cancel(false);
            this.jobHandle = null;
        }
    }
}

