/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache.monitor;

import org.neo4j.helpers.Format;
import org.neo4j.kernel.impl.pagecache.monitor.PageCacheWarmerMonitorAdapter;
import org.neo4j.logging.Log;

public class PageCacheWarmerLoggingMonitor
extends PageCacheWarmerMonitorAdapter {
    private final Log log;
    private long warmupStartMillis;

    public PageCacheWarmerLoggingMonitor(Log log) {
        this.log = log;
    }

    @Override
    public void warmupStarted() {
        this.warmupStartMillis = System.currentTimeMillis();
        this.log.info("Page cache warmup started.");
    }

    @Override
    public void warmupCompleted(long pagesLoaded) {
        this.log.info("Page cache warmup completed. %d pages loaded. Duration: %s.", new Object[]{pagesLoaded, PageCacheWarmerLoggingMonitor.getDuration(this.warmupStartMillis)});
    }

    private static String getDuration(long startTimeMillis) {
        return Format.duration((long)(System.currentTimeMillis() - startTimeMillis));
    }
}

