/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.highlimit;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.BaseRecordFormat;
import org.neo4j.kernel.impl.store.format.highlimit.BaseHighLimitRecordFormat;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

class RelationshipGroupRecordFormat
extends BaseHighLimitRecordFormat<RelationshipGroupRecord> {
    private static final int TYPE_BYTES = 3;
    static final int RECORD_SIZE = 32;
    static final int FIXED_FORMAT_RECORD_SIZE = 25;
    private static final int HAS_OUTGOING_BIT = 8;
    private static final int HAS_INCOMING_BIT = 16;
    private static final int HAS_LOOP_BIT = 32;
    private static final int HAS_NEXT_BIT = 64;
    private static final int NEXT_RECORD_BIT = 1;
    private static final int FIRST_OUT_BIT = 2;
    private static final int FIRST_IN_BIT = 4;
    private static final int FIRST_LOOP_BIT = 8;
    private static final int OWNING_NODE_BIT = 16;
    private static final long ONE_BIT_OVERFLOW_BIT_MASK = -8589934592L;
    private static final long HIGH_DWORD_LAST_BIT_MASK = 0x100000000L;

    RelationshipGroupRecordFormat() {
        this(32);
    }

    RelationshipGroupRecordFormat(int recordSize) {
        super(RelationshipGroupRecordFormat.fixedRecordSize((int)recordSize), 0, 50);
    }

    public RelationshipGroupRecord newRecord() {
        return new RelationshipGroupRecord(-1L);
    }

    @Override
    protected void doReadInternal(RelationshipGroupRecord record, PageCursor cursor, int recordSize, long headerByte, boolean inUse) {
        if (record.isUseFixedReferences()) {
            this.readFixedReferencesMethod(record, cursor, inUse);
            record.setUseFixedReferences(true);
        } else {
            int type = this.getType(cursor);
            record.initialize(inUse, type, RelationshipGroupRecordFormat.decodeCompressedReference(cursor, headerByte, 8, NULL), RelationshipGroupRecordFormat.decodeCompressedReference(cursor, headerByte, 16, NULL), RelationshipGroupRecordFormat.decodeCompressedReference(cursor, headerByte, 32, NULL), RelationshipGroupRecordFormat.decodeCompressedReference(cursor), RelationshipGroupRecordFormat.decodeCompressedReference(cursor, headerByte, 64, NULL));
        }
    }

    @Override
    protected byte headerBits(RelationshipGroupRecord record) {
        byte header = 0;
        header = RelationshipGroupRecordFormat.set(header, 8, record.getFirstOut(), NULL);
        header = RelationshipGroupRecordFormat.set(header, 16, record.getFirstIn(), NULL);
        header = RelationshipGroupRecordFormat.set(header, 32, record.getFirstLoop(), NULL);
        header = RelationshipGroupRecordFormat.set(header, 64, record.getNext(), NULL);
        return header;
    }

    @Override
    protected int requiredDataLength(RelationshipGroupRecord record) {
        return 3 + RelationshipGroupRecordFormat.length(record.getFirstOut(), NULL) + RelationshipGroupRecordFormat.length(record.getFirstIn(), NULL) + RelationshipGroupRecordFormat.length(record.getFirstLoop(), NULL) + RelationshipGroupRecordFormat.length(record.getOwningNode()) + RelationshipGroupRecordFormat.length(record.getNext(), NULL);
    }

    @Override
    protected void doWriteInternal(RelationshipGroupRecord record, PageCursor cursor) {
        if (record.isUseFixedReferences()) {
            this.writeFixedReferencesRecord(record, cursor);
        } else {
            this.writeType(cursor, record.getType());
            RelationshipGroupRecordFormat.encode(cursor, record.getFirstOut(), NULL);
            RelationshipGroupRecordFormat.encode(cursor, record.getFirstIn(), NULL);
            RelationshipGroupRecordFormat.encode(cursor, record.getFirstLoop(), NULL);
            RelationshipGroupRecordFormat.encode(cursor, record.getOwningNode());
            RelationshipGroupRecordFormat.encode(cursor, record.getNext(), NULL);
        }
    }

    @Override
    protected boolean canUseFixedReferences(RelationshipGroupRecord record, int recordSize) {
        return !(!this.isRecordBigEnoughForFixedReferences(recordSize) || record.getNext() != NULL && (record.getNext() & 0xFFFFFFFE00000000L) != 0L || record.getFirstOut() != NULL && (record.getFirstOut() & 0xFFFFFFFE00000000L) != 0L || record.getFirstIn() != NULL && (record.getFirstIn() & 0xFFFFFFFE00000000L) != 0L || record.getFirstLoop() != NULL && (record.getFirstLoop() & 0xFFFFFFFE00000000L) != 0L || record.getOwningNode() != NULL && (record.getOwningNode() & 0xFFFFFFFE00000000L) != 0L);
    }

    private boolean isRecordBigEnoughForFixedReferences(int recordSize) {
        return 25 <= recordSize;
    }

    private void readFixedReferencesMethod(RelationshipGroupRecord record, PageCursor cursor, boolean inUse) {
        long modifiers = cursor.getByte();
        int type = this.getType(cursor);
        long nextLowBits = (long)cursor.getInt() & 0xFFFFFFFFL;
        long firstOutLowBits = (long)cursor.getInt() & 0xFFFFFFFFL;
        long firstInLowBits = (long)cursor.getInt() & 0xFFFFFFFFL;
        long firstLoopLowBits = (long)cursor.getInt() & 0xFFFFFFFFL;
        long owningNodeLowBits = (long)cursor.getInt() & 0xFFFFFFFFL;
        long nextMod = (modifiers & 1L) << 32;
        long firstOutMod = (modifiers & 2L) << 31;
        long firstInMod = (modifiers & 4L) << 30;
        long firstLoopMod = (modifiers & 8L) << 29;
        long owningNodeMod = (modifiers & 0x10L) << 28;
        record.initialize(inUse, type, BaseRecordFormat.longFromIntAndMod((long)firstOutLowBits, (long)firstOutMod), BaseRecordFormat.longFromIntAndMod((long)firstInLowBits, (long)firstInMod), BaseRecordFormat.longFromIntAndMod((long)firstLoopLowBits, (long)firstLoopMod), BaseRecordFormat.longFromIntAndMod((long)owningNodeLowBits, (long)owningNodeMod), BaseRecordFormat.longFromIntAndMod((long)nextLowBits, (long)nextMod));
    }

    private void writeFixedReferencesRecord(RelationshipGroupRecord record, PageCursor cursor) {
        long nextMod = record.getNext() == NULL ? 0L : (record.getNext() & 0x100000000L) >> 32;
        long firstOutMod = record.getFirstOut() == NULL ? 0L : (record.getFirstOut() & 0x100000000L) >> 31;
        long firstInMod = record.getFirstIn() == NULL ? 0L : (record.getFirstIn() & 0x100000000L) >> 30;
        long firstLoopMod = record.getFirstLoop() == NULL ? 0L : (record.getFirstLoop() & 0x100000000L) >> 29;
        long owningNodeMod = record.getOwningNode() == NULL ? 0L : (record.getOwningNode() & 0x100000000L) >> 28;
        cursor.putByte((byte)(nextMod | firstOutMod | firstInMod | firstLoopMod | owningNodeMod));
        this.writeType(cursor, record.getType());
        cursor.putInt((int)record.getNext());
        cursor.putInt((int)record.getFirstOut());
        cursor.putInt((int)record.getFirstIn());
        cursor.putInt((int)record.getFirstLoop());
        cursor.putInt((int)record.getOwningNode());
    }

    private int getType(PageCursor cursor) {
        int typeLowWord = cursor.getShort() & 0xFFFF;
        int typeHighByte = cursor.getByte() & 0xFF;
        return typeHighByte << 16 | typeLowWord;
    }

    private void writeType(PageCursor cursor, int type) {
        cursor.putShort((short)type);
        cursor.putByte((byte)(type >>> 16));
    }
}

