/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.highlimit.v310;

import java.io.IOException;
import java.util.function.Function;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.impl.CompositePageCursor;
import org.neo4j.kernel.impl.store.RecordPageLocationCalculator;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.format.highlimit.Reference;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;

abstract class BaseHighLimitRecordFormatV3_1_0<RECORD extends AbstractBaseRecord>
extends BaseOneByteHeaderRecordFormat<RECORD> {
    static final int HEADER_BYTE = 1;
    static final long NULL = Record.NULL_REFERENCE.intValue();
    static final int HEADER_BIT_RECORD_UNIT = 2;
    static final int HEADER_BIT_FIRST_RECORD_UNIT = 4;
    static final int HEADER_BIT_FIXED_REFERENCE = 4;

    protected BaseHighLimitRecordFormatV3_1_0(Function<StoreHeader, Integer> recordSize, int recordHeaderSize) {
        super(recordSize, recordHeaderSize, 1, 50);
    }

    public void read(RECORD record, PageCursor primaryCursor, RecordLoad mode, int recordSize) throws IOException {
        int primaryStartOffset = primaryCursor.getOffset();
        byte headerByte = primaryCursor.getByte();
        boolean inUse = this.isInUse(headerByte);
        boolean doubleRecordUnit = BaseHighLimitRecordFormatV3_1_0.has((long)headerByte, (int)2);
        record.setUseFixedReferences(false);
        if (doubleRecordUnit) {
            boolean firstRecordUnit = BaseHighLimitRecordFormatV3_1_0.has((long)headerByte, (int)4);
            if (!firstRecordUnit) {
                record.clear();
                primaryCursor.setCursorException("Expected record to be the first unit in the chain, but record header says it's not");
                return;
            }
            long secondaryId = Reference.decode(primaryCursor);
            long pageId = RecordPageLocationCalculator.pageIdForRecord((long)secondaryId, (int)primaryCursor.getCurrentPageSize(), (int)recordSize);
            int offset = RecordPageLocationCalculator.offsetForId((long)secondaryId, (int)primaryCursor.getCurrentPageSize(), (int)recordSize);
            PageCursor secondaryCursor = primaryCursor.openLinkedCursor(pageId);
            if (!secondaryCursor.next() | offset < 0) {
                record.clear();
                primaryCursor.setCursorException(this.illegalSecondaryReferenceMessage(pageId));
                return;
            }
            secondaryCursor.setOffset(offset + 1);
            int primarySize = recordSize - (primaryCursor.getOffset() - primaryStartOffset);
            int secondarySize = recordSize - 1;
            PageCursor composite = CompositePageCursor.compose((PageCursor)primaryCursor, (int)primarySize, (PageCursor)secondaryCursor, (int)secondarySize);
            this.doReadInternal(record, composite, recordSize, headerByte, inUse);
            record.setSecondaryUnitId(secondaryId);
        } else {
            record.setUseFixedReferences(this.isUseFixedReferences(headerByte));
            this.doReadInternal(record, primaryCursor, recordSize, headerByte, inUse);
        }
        primaryCursor.setOffset(primaryStartOffset + recordSize);
    }

    private boolean isUseFixedReferences(byte headerByte) {
        return !BaseHighLimitRecordFormatV3_1_0.has((long)headerByte, (int)4);
    }

    private String illegalSecondaryReferenceMessage(long secondaryId) {
        return "Illegal secondary record reference: " + secondaryId;
    }

    protected abstract void doReadInternal(RECORD var1, PageCursor var2, int var3, long var4, boolean var6);

    public void write(RECORD record, PageCursor primaryCursor, int recordSize) throws IOException {
        if (record.inUse()) {
            byte headerByte = this.headerBits(record);
            assert ((headerByte & 7) == 0) : "Format-specific header bits (" + headerByte + ") collides with format-generic header bits";
            headerByte = BaseHighLimitRecordFormatV3_1_0.set((byte)headerByte, (int)1, (boolean)record.inUse());
            headerByte = BaseHighLimitRecordFormatV3_1_0.set((byte)headerByte, (int)2, (boolean)record.requiresSecondaryUnit());
            headerByte = record.requiresSecondaryUnit() ? BaseHighLimitRecordFormatV3_1_0.set((byte)headerByte, (int)4, (boolean)true) : BaseHighLimitRecordFormatV3_1_0.set((byte)headerByte, (int)4, (!record.isUseFixedReferences() ? 1 : 0) != 0);
            primaryCursor.putByte(headerByte);
            if (record.requiresSecondaryUnit()) {
                long secondaryUnitId = record.getSecondaryUnitId();
                long pageId = RecordPageLocationCalculator.pageIdForRecord((long)secondaryUnitId, (int)primaryCursor.getCurrentPageSize(), (int)recordSize);
                int offset = RecordPageLocationCalculator.offsetForId((long)secondaryUnitId, (int)primaryCursor.getCurrentPageSize(), (int)recordSize);
                PageCursor secondaryCursor = primaryCursor.openLinkedCursor(pageId);
                if (!secondaryCursor.next()) {
                    record.clear();
                    return;
                }
                secondaryCursor.setOffset(offset);
                secondaryCursor.putByte((byte)3);
                int recordSizeWithoutHeader = recordSize - 1;
                PageCursor composite = CompositePageCursor.compose((PageCursor)primaryCursor, (int)recordSizeWithoutHeader, (PageCursor)secondaryCursor, (int)recordSizeWithoutHeader);
                Reference.encode(secondaryUnitId, composite);
                this.doWriteInternal(record, composite);
            } else {
                this.doWriteInternal(record, primaryCursor);
            }
        } else {
            this.markAsUnused(primaryCursor, record, recordSize);
        }
    }

    protected void markAsUnused(PageCursor cursor, RECORD record, int recordSize) throws IOException {
        this.markAsUnused(cursor);
        if (record.hasSecondaryUnitId()) {
            long secondaryUnitId = record.getSecondaryUnitId();
            long pageIdForSecondaryRecord = RecordPageLocationCalculator.pageIdForRecord((long)secondaryUnitId, (int)cursor.getCurrentPageSize(), (int)recordSize);
            int offsetForSecondaryId = RecordPageLocationCalculator.offsetForId((long)secondaryUnitId, (int)cursor.getCurrentPageSize(), (int)recordSize);
            if (!cursor.next(pageIdForSecondaryRecord)) {
                throw new UnderlyingStorageException("Couldn't move to secondary page " + pageIdForSecondaryRecord);
            }
            cursor.setOffset(offsetForSecondaryId);
            this.markAsUnused(cursor);
        }
    }

    protected abstract void doWriteInternal(RECORD var1, PageCursor var2);

    protected abstract byte headerBits(RECORD var1);

    public final void prepare(RECORD record, int recordSize, IdSequence idSequence) {
        if (record.inUse()) {
            record.setUseFixedReferences(this.canUseFixedReferences(record, recordSize));
            if (!record.isUseFixedReferences()) {
                int requiredLength = 1 + this.requiredDataLength(record);
                boolean requiresSecondaryUnit = requiredLength > recordSize;
                record.setRequiresSecondaryUnit(requiresSecondaryUnit);
                if (record.requiresSecondaryUnit() && !record.hasSecondaryUnitId()) {
                    record.setSecondaryUnitId(idSequence.nextId());
                }
            }
        }
    }

    protected abstract boolean canUseFixedReferences(RECORD var1, int var2);

    protected abstract int requiredDataLength(RECORD var1);

    protected static int length(long reference) {
        return Reference.length(reference);
    }

    protected static int length(long reference, long nullValue) {
        return reference == nullValue ? 0 : BaseHighLimitRecordFormatV3_1_0.length(reference);
    }

    protected static long decodeCompressedReference(PageCursor cursor) {
        return Reference.decode(cursor);
    }

    protected static long decodeCompressedReference(PageCursor cursor, long headerByte, int headerBitMask, long nullValue) {
        return BaseHighLimitRecordFormatV3_1_0.has((long)headerByte, (int)headerBitMask) ? BaseHighLimitRecordFormatV3_1_0.decodeCompressedReference(cursor) : nullValue;
    }

    protected static void encode(PageCursor cursor, long reference) {
        Reference.encode(reference, cursor);
    }

    protected static void encode(PageCursor cursor, long reference, long nullValue) {
        if (reference != nullValue) {
            Reference.encode(reference, cursor);
        }
    }

    protected static byte set(byte header, int bitMask, long reference, long nullValue) {
        return BaseHighLimitRecordFormatV3_1_0.set((byte)header, (int)bitMask, (reference != nullValue ? 1 : 0) != 0);
    }
}

