/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen.profiling;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypher.internal.codegen.QueryExecutionTracer;
import org.neo4j.cypher.internal.planner.v3_5.spi.KernelStatisticProvider;
import org.neo4j.cypher.internal.runtime.compiled.codegen.QueryExecutionEvent;
import org.neo4j.cypher.internal.v3_5.util.attribution.Id;
import org.neo4j.cypher.result.OperatorProfile;
import org.neo4j.cypher.result.QueryProfile;

public class ProfilingTracer
implements QueryExecutionTracer,
QueryProfile {
    private static final Data ZERO = new Data();
    private final Clock clock;
    private final KernelStatisticProvider statisticProvider;
    private final Map<Integer, Data> data = new HashMap<Integer, Data>();

    public ProfilingTracer(KernelStatisticProvider statisticProvider) {
        this(Clock.SYSTEM_TIMER, statisticProvider);
    }

    ProfilingTracer(Clock clock, KernelStatisticProvider statisticProvider) {
        this.clock = clock;
        this.statisticProvider = statisticProvider;
    }

    public OperatorProfile operatorProfile(int query) {
        Data value = this.data.get(query);
        return value == null ? ZERO : value;
    }

    public long timeOf(Id query) {
        return this.operatorProfile(query.x()).time();
    }

    public long dbHitsOf(Id query) {
        return this.operatorProfile(query.x()).dbHits();
    }

    public long rowsOf(Id query) {
        return this.operatorProfile(query.x()).rows();
    }

    @Override
    public QueryExecutionEvent executeOperator(Id queryId) {
        Data queryData = this.data.get(queryId.x());
        if (queryData == null) {
            queryData = new Data();
            this.data.put(queryId.x(), queryData);
        }
        return new ExecutionEvent(this.clock, this.statisticProvider, queryData);
    }

    private static class Data
    implements OperatorProfile {
        private long time;
        private long hits;
        private long rows;
        private long pageCacheHits;
        private long pageCacheMisses;

        private Data() {
        }

        public void update(long time, long hits, long rows, long pageCacheHits, long pageCacheMisses) {
            this.time += time;
            this.hits += hits;
            this.rows += rows;
            this.pageCacheHits += pageCacheHits;
            this.pageCacheMisses += pageCacheMisses;
        }

        public long time() {
            return this.time;
        }

        public long dbHits() {
            return this.hits;
        }

        public long rows() {
            return this.rows;
        }

        public long pageCacheHits() {
            return this.pageCacheHits;
        }

        public long pageCacheMisses() {
            return this.pageCacheMisses;
        }
    }

    private static class ExecutionEvent
    implements QueryExecutionEvent {
        private final long start;
        private final Clock clock;
        private final KernelStatisticProvider statisticProvider;
        private final Data data;
        private long hitCount;
        private long rowCount;

        ExecutionEvent(Clock clock, KernelStatisticProvider statisticProvider, Data data) {
            this.clock = clock;
            this.statisticProvider = statisticProvider;
            this.data = data;
            this.start = clock.nanoTime();
        }

        @Override
        public void close() {
            long executionTime = this.clock.nanoTime() - this.start;
            long pageCacheHits = this.statisticProvider.getPageCacheHits();
            long pageCacheFaults = this.statisticProvider.getPageCacheMisses();
            if (this.data != null) {
                this.data.update(executionTime, this.hitCount, this.rowCount, pageCacheHits, pageCacheFaults);
            }
        }

        @Override
        public void dbHit() {
            ++this.hitCount;
        }

        @Override
        public void row() {
            ++this.rowCount;
        }
    }

    public static interface Clock {
        public static final Clock SYSTEM_TIMER = System::nanoTime;

        public long nanoTime();
    }
}

