/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.ZoneId;
import java.util.function.Supplier;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.query.ConfiguredQueryLogger;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QueryLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;

class DynamicLoggingQueryExecutionMonitor
extends LifecycleAdapter
implements QueryExecutionMonitor {
    private final Config config;
    private final FileSystemAbstraction fileSystem;
    private final JobScheduler scheduler;
    private final Log debugLog;
    private volatile QueryLogger currentLog = QueryLogger.NO_LOG;
    private ZoneId currentLogTimeZone;
    private FormattedLog.Builder logBuilder;
    private File currentQueryLogFile;
    private long currentRotationThreshold;
    private int currentMaxArchives;
    private Log log;
    private Closeable closable;

    DynamicLoggingQueryExecutionMonitor(Config config, FileSystemAbstraction fileSystem, JobScheduler scheduler, Log debugLog) {
        this.config = config;
        this.fileSystem = fileSystem;
        this.scheduler = scheduler;
        this.debugLog = debugLog;
    }

    public synchronized void init() {
        this.currentLogTimeZone = ((LogTimeZone)this.config.get(GraphDatabaseSettings.db_timezone)).getZoneId();
        this.logBuilder = FormattedLog.withZoneId((ZoneId)this.currentLogTimeZone);
        this.currentQueryLogFile = (File)this.config.get(GraphDatabaseSettings.log_queries_filename);
        this.updateSettings();
        this.registerDynamicSettingUpdater(GraphDatabaseSettings.log_queries);
        this.registerDynamicSettingUpdater(GraphDatabaseSettings.log_queries_threshold);
        this.registerDynamicSettingUpdater(GraphDatabaseSettings.log_queries_rotation_threshold);
        this.registerDynamicSettingUpdater(GraphDatabaseSettings.log_queries_max_archives);
        this.registerDynamicSettingUpdater(GraphDatabaseSettings.log_queries_runtime_logging_enabled);
        this.registerDynamicSettingUpdater(GraphDatabaseSettings.log_queries_parameter_logging_enabled);
        this.registerDynamicSettingUpdater(GraphDatabaseSettings.log_queries_page_detail_logging_enabled);
        this.registerDynamicSettingUpdater(GraphDatabaseSettings.log_queries_allocation_logging_enabled);
        this.registerDynamicSettingUpdater(GraphDatabaseSettings.log_queries_detailed_time_logging_enabled);
    }

    private <T> void registerDynamicSettingUpdater(Setting<T> setting) {
        this.config.registerDynamicUpdateListener(setting, (a, b) -> this.updateSettings());
    }

    private synchronized void updateSettings() {
        this.updateLogSettings();
        this.updateQueryLoggerSettings();
    }

    private void updateQueryLoggerSettings() {
        this.currentLog = (Boolean)this.config.get(GraphDatabaseSettings.log_queries) != false ? new ConfiguredQueryLogger(this.log, this.config) : QueryLogger.NO_LOG;
    }

    private void updateLogSettings() {
        if (((Boolean)this.config.get(GraphDatabaseSettings.log_queries)).booleanValue()) {
            long rotationThreshold = (Long)this.config.get(GraphDatabaseSettings.log_queries_rotation_threshold);
            int maxArchives = (Integer)this.config.get(GraphDatabaseSettings.log_queries_max_archives);
            try {
                if (this.logRotationIsEnabled(rotationThreshold)) {
                    boolean needsRebuild = this.closable == null;
                    needsRebuild |= this.currentRotationThreshold != rotationThreshold;
                    if (needsRebuild |= this.currentMaxArchives != maxArchives) {
                        this.closeCurrentLogIfAny();
                        this.buildRotatingLog(rotationThreshold, maxArchives);
                    }
                } else if (this.currentRotationThreshold != rotationThreshold || this.closable == null) {
                    this.closeCurrentLogIfAny();
                    this.buildNonRotatingLog();
                }
                this.currentRotationThreshold = rotationThreshold;
                this.currentMaxArchives = maxArchives;
            }
            catch (IOException exception) {
                this.debugLog.warn("Failed to build query log", (Throwable)exception);
            }
        } else {
            this.closeCurrentLogIfAny();
        }
    }

    private boolean logRotationIsEnabled(long threshold) {
        return threshold > 0L;
    }

    private void closeCurrentLogIfAny() {
        if (this.closable != null) {
            try {
                this.closable.close();
            }
            catch (IOException exception) {
                this.debugLog.warn("Failed to close current log: " + this.closable, (Throwable)exception);
            }
            this.closable = null;
        }
    }

    private void buildRotatingLog(long rotationThreshold, int maxArchives) throws IOException {
        RotatingFileOutputStreamSupplier rotatingSupplier = new RotatingFileOutputStreamSupplier(this.fileSystem, this.currentQueryLogFile, rotationThreshold, 0L, maxArchives, this.scheduler.executor(Group.LOG_ROTATION));
        this.log = this.logBuilder.toOutputStream((Supplier)rotatingSupplier);
        this.closable = rotatingSupplier;
    }

    private void buildNonRotatingLog() throws IOException {
        OutputStream logOutputStream = Files.createOrOpenAsOutputStream((FileSystemAbstraction)this.fileSystem, (File)this.currentQueryLogFile, (boolean)true);
        this.log = this.logBuilder.toOutputStream(logOutputStream);
        this.closable = logOutputStream;
    }

    public synchronized void shutdown() {
        this.closeCurrentLogIfAny();
    }

    public void endFailure(ExecutingQuery query, Throwable failure) {
        this.currentLog.failure(query, failure);
    }

    public void endSuccess(ExecutingQuery query) {
        this.currentLog.success(query);
    }
}

