/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.query.DynamicLoggingQueryExecutionMonitor;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;

public class QueryLoggerKernelExtension
extends KernelExtensionFactory<Dependencies> {
    public QueryLoggerKernelExtension() {
        super(ExtensionType.DATABASE, "query-logging");
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) {
        final FileSystemAbstraction fileSystem = dependencies.fileSystem();
        final Config config = dependencies.config();
        final Monitors monitoring = dependencies.monitoring();
        final LogService logService = dependencies.logger();
        final JobScheduler jobScheduler = dependencies.jobScheduler();
        return new LifecycleAdapter(){
            DynamicLoggingQueryExecutionMonitor logger;

            public void init() {
                Log debugLog = logService.getInternalLog(DynamicLoggingQueryExecutionMonitor.class);
                this.logger = new DynamicLoggingQueryExecutionMonitor(config, fileSystem, jobScheduler, debugLog);
                this.logger.init();
                monitoring.addMonitorListener((Object)this.logger, new String[0]);
            }

            public void shutdown() {
                this.logger.shutdown();
            }
        };
    }

    public static interface Dependencies {
        public FileSystemAbstraction fileSystem();

        public Config config();

        public Monitors monitoring();

        public LogService logger();

        public JobScheduler jobScheduler();
    }
}

