/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.ddata.protobuf;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Address$;
import akka.cluster.UniqueAddress;
import akka.cluster.ddata.VersionVector;
import akka.cluster.ddata.VersionVector$;
import akka.cluster.ddata.protobuf.SerializationSupport;
import akka.cluster.ddata.protobuf.msg.ReplicatorMessages;
import akka.protobuf.ByteString;
import akka.protobuf.MessageLite;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.Serializers$;
import akka.util.ccompat.package;
import akka.util.ccompat.package$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class SerializationSupport$class {
    public static Serialization serialization(SerializationSupport $this) {
        if ($this.akka$cluster$ddata$protobuf$SerializationSupport$$ser() == null) {
            $this.akka$cluster$ddata$protobuf$SerializationSupport$$ser_$eq((Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)$this.system()));
        }
        return $this.akka$cluster$ddata$protobuf$SerializationSupport$$ser();
    }

    public static String addressProtocol(SerializationSupport $this) {
        if ($this.akka$cluster$ddata$protobuf$SerializationSupport$$protocol() == null) {
            $this.akka$cluster$ddata$protobuf$SerializationSupport$$protocol_$eq($this.system().provider().getDefaultAddress().protocol());
        }
        return $this.akka$cluster$ddata$protobuf$SerializationSupport$$protocol();
    }

    public static Serialization.Information transportInformation(SerializationSupport $this) {
        if ($this.akka$cluster$ddata$protobuf$SerializationSupport$$transportInfo() == null) {
            Address address = $this.system().provider().getDefaultAddress();
            $this.akka$cluster$ddata$protobuf$SerializationSupport$$transportInfo_$eq(new Serialization.Information(address, (ActorSystem)$this.system()));
        }
        return $this.akka$cluster$ddata$protobuf$SerializationSupport$$transportInfo();
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] compress(SerializationSupport $this, MessageLite msg) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        GZIPOutputStream zip = new GZIPOutputStream(bos);
        try {
            msg.writeTo((OutputStream)zip);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        zip.close();
        return bos.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decompress(SerializationSupport $this, byte[] bytes) {
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            SerializationSupport$class.readChunk$1($this, in, out, buffer);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        in.close();
        return out.toByteArray();
    }

    public static ReplicatorMessages.Address.Builder addressToProto(SerializationSupport $this, Address address) {
        Address address2 = address;
        if (address2 != null) {
            Option option = address2.host();
            Option option2 = address2.port();
            if (option instanceof Some) {
                Some some = (Some)option;
                String host = (String)some.x();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    int port = BoxesRunTime.unboxToInt((Object)some2.x());
                    ReplicatorMessages.Address.Builder builder = ReplicatorMessages.Address.newBuilder().setHostname(host).setPort(port);
                    return builder;
                }
            }
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Address [", "] could not be serialized: host or port missing."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address})));
    }

    public static Address addressFromProto(SerializationSupport $this, ReplicatorMessages.Address address) {
        return Address$.MODULE$.apply($this.addressProtocol(), $this.system().name(), address.getHostname(), address.getPort());
    }

    public static ReplicatorMessages.UniqueAddress.Builder uniqueAddressToProto(SerializationSupport $this, UniqueAddress uniqueAddress) {
        return ReplicatorMessages.UniqueAddress.newBuilder().setAddress($this.addressToProto(uniqueAddress.address())).setUid((int)uniqueAddress.longUid()).setUid2((int)(uniqueAddress.longUid() >> 32));
    }

    public static UniqueAddress uniqueAddressFromProto(SerializationSupport $this, ReplicatorMessages.UniqueAddress uniqueAddress) {
        return new UniqueAddress($this.addressFromProto(uniqueAddress.getAddress()), uniqueAddress.hasUid2() ? (long)uniqueAddress.getUid2() << 32 | (long)uniqueAddress.getUid() & 0xFFFFFFFFL : (long)uniqueAddress.getUid());
    }

    public static ReplicatorMessages.VersionVector versionVectorToProto(SerializationSupport $this, VersionVector versionVector) {
        ReplicatorMessages.VersionVector.Builder b = ReplicatorMessages.VersionVector.newBuilder();
        versionVector.versionsIterator().foreach((Function1)new Serializable($this, b){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SerializationSupport $outer;
            private final ReplicatorMessages.VersionVector.Builder b$1;

            public final ReplicatorMessages.VersionVector.Builder apply(Tuple2<UniqueAddress, Object> x0$1) {
                Tuple2<UniqueAddress, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    UniqueAddress node = (UniqueAddress)tuple2._1();
                    long value2 = tuple2._2$mcJ$sp();
                    ReplicatorMessages.VersionVector.Builder builder = this.b$1.addEntries(ReplicatorMessages.VersionVector.Entry.newBuilder().setNode(this.$outer.uniqueAddressToProto(node)).setVersion(value2));
                    return builder;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.b$1 = b$1;
            }
        });
        return b.build();
    }

    public static VersionVector versionVectorFromBinary(SerializationSupport $this, byte[] bytes) {
        return $this.versionVectorFromProto(ReplicatorMessages.VersionVector.parseFrom(bytes));
    }

    public static VersionVector versionVectorFromProto(SerializationSupport $this, ReplicatorMessages.VersionVector versionVector) {
        VersionVector versionVector2;
        List<ReplicatorMessages.VersionVector.Entry> entries2 = versionVector.getEntriesList();
        if (entries2.isEmpty()) {
            versionVector2 = VersionVector$.MODULE$.empty();
        } else if (entries2.size() == 1) {
            versionVector2 = VersionVector$.MODULE$.apply($this.uniqueAddressFromProto(entries2.get(0).getNode()), entries2.get(0).getVersion());
        } else {
            TreeMap versions = package.ImmutableTreeMapExtensions$.MODULE$.from$extension(package$.MODULE$.ImmutableTreeMapExtensions(TreeMap$.MODULE$), (TraversableOnce)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(versionVector.getEntriesList()).asScala()).iterator().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SerializationSupport $outer;

                public final Tuple2<UniqueAddress, Object> apply(ReplicatorMessages.VersionVector.Entry entry) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.uniqueAddressFromProto(entry.getNode())), (Object)BoxesRunTime.boxToLong((long)entry.getVersion()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            versionVector2 = VersionVector$.MODULE$.apply((TreeMap<UniqueAddress, Object>)versions);
        }
        return versionVector2;
    }

    public static ActorRef resolveActorRef(SerializationSupport $this, String path) {
        return $this.system().provider().resolveActorRef(path);
    }

    /*
     * WARNING - void declaration
     */
    public static ReplicatorMessages.OtherMessage otherMessageToProto(SerializationSupport $this, Object msg) {
        ReplicatorMessages.OtherMessage otherMessage;
        Serialization.Information oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)$this.system().provider().serializationInformation());
            }
            otherMessage = SerializationSupport$class.buildOther$1($this, msg);
        }
        catch (Throwable throwable) {
            void var2_2;
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)var2_2);
            throw throwable;
        }
        Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        return otherMessage;
    }

    public static Object otherMessageFromBinary(SerializationSupport $this, byte[] bytes) {
        return $this.otherMessageFromProto(ReplicatorMessages.OtherMessage.parseFrom(bytes));
    }

    public static Object otherMessageFromProto(SerializationSupport $this, ReplicatorMessages.OtherMessage other) {
        String manifest = other.hasMessageManifest() ? other.getMessageManifest().toStringUtf8() : "";
        return $this.serialization().deserialize(other.getEnclosedMessage().toByteArray(), other.getSerializerId(), manifest).get();
    }

    private static final void readChunk$1(SerializationSupport $this, GZIPInputStream in$1, ByteArrayOutputStream out$1, byte[] buffer$1) {
        block3: while (true) {
            int n = in$1.read(buffer$1);
            switch (n) {
                default: {
                    out$1.write(buffer$1, 0, n);
                    continue block3;
                }
                case -1: 
            }
            break;
        }
    }

    private static final ReplicatorMessages.OtherMessage buildOther$1(SerializationSupport $this, Object msg$1) {
        Object m = msg$1;
        Serializer msgSerializer = $this.serialization().findSerializerFor(m);
        ReplicatorMessages.OtherMessage.Builder builder = ReplicatorMessages.OtherMessage.newBuilder().setEnclosedMessage(ByteString.copyFrom((byte[])msgSerializer.toBinary(m))).setSerializerId(msgSerializer.identifier());
        String ms = Serializers$.MODULE$.manifestFor(msgSerializer, m);
        Object object = new StringOps(Predef$.MODULE$.augmentString(ms)).nonEmpty() ? builder.setMessageManifest(ByteString.copyFromUtf8((String)ms)) : BoxedUnit.UNIT;
        return builder.build();
    }

    public static void $init$(SerializationSupport $this) {
    }
}

