/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.parallel;

import org.neo4j.cypher.internal.runtime.parallel.DataPoint;
import org.neo4j.cypher.internal.runtime.parallel.RingBuffer$;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001y<Q!\u0001\u0002\t\u0002=\t!BU5oO\n+hMZ3s\u0015\t\u0019A!\u0001\u0005qCJ\fG\u000e\\3m\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005%Q\u0011AB2za\",'O\u0003\u0002\f\u0019\u0005)a.Z85U*\tQ\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u0011#5\t!AB\u0003\u0013\u0005!\u00051C\u0001\u0006SS:<')\u001e4gKJ\u001c\"!\u0005\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g\u0011\u0015Y\u0012\u0003\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tq\u0002C\u0004\u001f#\t\u0007I\u0011A\u0010\u0002\u001d\u0011,g-Y;mi\nKGoU5{KV\t\u0001\u0005\u0005\u0002\u0016C%\u0011!E\u0006\u0002\u0004\u0013:$\bB\u0002\u0013\u0012A\u0003%\u0001%A\beK\u001a\fW\u000f\u001c;CSR\u001c\u0016N_3!\u0011\u001d1\u0013C1A\u0005\u0002}\t\u0011\u0003Z3gCVdG/T1y%\u0016$(/[3t\u0011\u0019A\u0013\u0003)A\u0005A\u0005\u0011B-\u001a4bk2$X*\u0019=SKR\u0014\u0018.Z:!\u0011\u001dQ\u0013#%A\u0005\u0002-\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nT#\u0001\u0017+\u0005\u0001j3&\u0001\u0018\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014!C;oG\",7m[3e\u0015\t\u0019d#\u0001\u0006b]:|G/\u0019;j_:L!!\u000e\u0019\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u00048#E\u0005I\u0011A\u0016\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\r\u0011\u0011\"\u0001A\u001d\u0014\u0005a\"\u0002\u0002C\u001e9\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u000f\tLGoU5{K\"AQ\b\u000fBC\u0002\u0013%q$\u0001\u0006nCb\u0014V\r\u001e:jKND\u0001b\u0010\u001d\u0003\u0002\u0003\u0006I\u0001I\u0001\f[\u0006D(+\u001a;sS\u0016\u001c\b\u0005C\u0003\u001cq\u0011\u0005\u0011\tF\u0002C\u0007\u0012\u0003\"\u0001\u0005\u001d\t\u000fm\u0002\u0005\u0013!a\u0001A!9Q\b\u0011I\u0001\u0002\u0004\u0001\u0003b\u0002$9\u0001\u0004%IaH\u0001\raJ|G-^2f\u0007>,h\u000e\u001e\u0005\b\u0011b\u0002\r\u0011\"\u0003J\u0003A\u0001(o\u001c3vG\u0016\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002K\u001bB\u0011QcS\u0005\u0003\u0019Z\u0011A!\u00168ji\"9ajRA\u0001\u0002\u0004\u0001\u0013a\u0001=%c!1\u0001\u000b\u000fQ!\n\u0001\nQ\u0002\u001d:pIV\u001cWmQ8v]R\u0004\u0003FA(S!\t)2+\u0003\u0002U-\tAao\u001c7bi&dW\rC\u0004Wq\u0001\u0007I\u0011B\u0010\u0002\u0019\r|gn];nK\u000e{WO\u001c;\t\u000faC\u0004\u0019!C\u00053\u0006\u00012m\u001c8tk6,7i\\;oi~#S-\u001d\u000b\u0003\u0015jCqAT,\u0002\u0002\u0003\u0007\u0001\u0005\u0003\u0004]q\u0001\u0006K\u0001I\u0001\u000eG>t7/^7f\u0007>,h\u000e\u001e\u0011)\u0005m\u0013\u0006bB09\u0005\u0004%\taH\u0001\u0005g&TX\r\u0003\u0004bq\u0001\u0006I\u0001I\u0001\u0006g&TX\r\t\u0005\bGb\u0012\r\u0011\"\u0003 \u0003\u0011i\u0017m]6\t\r\u0015D\u0004\u0015!\u0003!\u0003\u0015i\u0017m]6!\u0011\u001d9\u0007H1A\u0005\n!\faAY;gM\u0016\u0014X#A5\u0011\u0007UQG.\u0003\u0002l-\t)\u0011I\u001d:bsB\u0011\u0001#\\\u0005\u0003]\n\u0011\u0011\u0002R1uCB{\u0017N\u001c;\t\rAD\u0004\u0015!\u0003j\u0003\u001d\u0011WO\u001a4fe\u0002BQA\u001d\u001d\u0005\u0002M\fq\u0001\u001d:pIV\u001cW\r\u0006\u0002Ki\")Q/\u001da\u0001Y\u0006\u0011A\r\u001d\u0005\u0006ob\"\t\u0001_\u0001\bG>t7/^7f)\tQ\u0015\u0010C\u0003{m\u0002\u000710A\u0001g!\u0011)B\u0010\u001c&\n\u0005u4\"!\u0003$v]\u000e$\u0018n\u001c82\u0001")
public class RingBuffer {
    private final int maxRetries;
    private volatile int produceCount;
    private volatile int consumeCount;
    private final int size;
    private final int mask;
    private final DataPoint[] buffer;

    public static int $lessinit$greater$default$2() {
        return RingBuffer$.MODULE$.$lessinit$greater$default$2();
    }

    public static int $lessinit$greater$default$1() {
        return RingBuffer$.MODULE$.$lessinit$greater$default$1();
    }

    public static int defaultMaxRetries() {
        return RingBuffer$.MODULE$.defaultMaxRetries();
    }

    public static int defaultBitSize() {
        return RingBuffer$.MODULE$.defaultBitSize();
    }

    private int maxRetries() {
        return this.maxRetries;
    }

    private int produceCount() {
        return this.produceCount;
    }

    private void produceCount_$eq(int x$1) {
        this.produceCount = x$1;
    }

    private int consumeCount() {
        return this.consumeCount;
    }

    private void consumeCount_$eq(int x$1) {
        this.consumeCount = x$1;
    }

    public int size() {
        return this.size;
    }

    private int mask() {
        return this.mask;
    }

    private DataPoint[] buffer() {
        return this.buffer;
    }

    public void produce(DataPoint dp) {
        int claimed = -1;
        int snapshotProduce = this.produceCount();
        int retries = 0;
        while (claimed == -1) {
            int snapshotConsume = this.consumeCount();
            if (snapshotProduce - this.size() < snapshotConsume) {
                claimed = snapshotProduce & this.mask();
                this.buffer()[claimed] = dp;
                this.produceCount_$eq(this.produceCount() + 1);
                continue;
            }
            if (++retries < this.maxRetries()) {
                Thread.sleep(0L, 1000);
                continue;
            }
            throw new RuntimeException("Exceeded max retries");
        }
    }

    public void consume(Function1<DataPoint, BoxedUnit> f) {
        int snapshotConsume;
        int snapshotProduce = this.produceCount();
        for (snapshotConsume = this.consumeCount(); snapshotConsume < snapshotProduce; ++snapshotConsume) {
            f.apply((Object)this.buffer()[snapshotConsume & this.mask()]);
        }
        this.consumeCount_$eq(snapshotConsume);
    }

    public RingBuffer(int bitSize, int maxRetries) {
        this.maxRetries = maxRetries;
        this.produceCount = 0;
        this.consumeCount = 0;
        this.size = 1 << bitSize;
        this.mask = this.size() - 1;
        this.buffer = new DataPoint[this.size()];
    }
}

