/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.vectorized.operators;

import java.util.Comparator;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.LongSlot;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.RefSlot;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.Slot;
import org.neo4j.cypher.internal.runtime.slotted.pipes.ColumnOrder;
import org.neo4j.cypher.internal.runtime.vectorized.Morsel;
import org.neo4j.cypher.internal.runtime.vectorized.MorselExecutionContext;
import org.neo4j.cypher.internal.runtime.vectorized.MorselExecutionContext$;
import org.neo4j.values.AnyValue;
import scala.MatchError;
import scala.Predef$;

public final class MorselSorting$ {
    public static final MorselSorting$ MODULE$;

    static {
        new MorselSorting$();
    }

    public Comparator<Integer> compareMorselIndexesByColumnOrder(MorselExecutionContext row, ColumnOrder order) {
        Slot slot;
        block4: {
            Comparator<Integer> comparator;
            block3: {
                block2: {
                    slot = order.slot();
                    if (!(slot instanceof LongSlot)) break block2;
                    LongSlot longSlot = (LongSlot)slot;
                    int offset = longSlot.offset();
                    comparator = new Comparator<Integer>(row, order, offset){
                        private final MorselExecutionContext row$1;
                        private final ColumnOrder order$2;
                        private final int offset$1;

                        public int compare(Integer idx1, Integer idx2) {
                            this.row$1.moveToRow(Predef$.MODULE$.Integer2int(idx1));
                            long aVal = this.row$1.getLongAt(this.offset$1);
                            this.row$1.moveToRow(Predef$.MODULE$.Integer2int(idx2));
                            long bVal = this.row$1.getLongAt(this.offset$1);
                            return this.order$2.compareLongs(aVal, bVal);
                        }
                        {
                            this.row$1 = row$1;
                            this.order$2 = order$2;
                            this.offset$1 = offset$1;
                        }
                    };
                    break block3;
                }
                if (!(slot instanceof RefSlot)) break block4;
                RefSlot refSlot = (RefSlot)slot;
                int offset = refSlot.offset();
                comparator = new Comparator<Integer>(row, order, offset){
                    private final MorselExecutionContext row$1;
                    private final ColumnOrder order$2;
                    private final int offset$2;

                    public int compare(Integer idx1, Integer idx2) {
                        this.row$1.moveToRow(Predef$.MODULE$.Integer2int(idx1));
                        AnyValue aVal = this.row$1.getRefAt(this.offset$2);
                        this.row$1.moveToRow(Predef$.MODULE$.Integer2int(idx2));
                        AnyValue bVal = this.row$1.getRefAt(this.offset$2);
                        return this.order$2.compareValues(aVal, bVal);
                    }
                    {
                        this.row$1 = row$1;
                        this.order$2 = order$2;
                        this.offset$2 = offset$2;
                    }
                };
            }
            return comparator;
        }
        throw new MatchError((Object)slot);
    }

    /*
     * WARNING - void declaration
     */
    public Integer[] createMorselIndexesArray(MorselExecutionContext row) {
        void var3_3;
        int rows = row.numberOfRows();
        Integer[] list = new Integer[rows];
        for (int idx = 0; idx < rows; ++idx) {
            list[idx] = Predef$.MODULE$.int2Integer(idx);
        }
        return var3_3;
    }

    public void createSortedMorselData(MorselExecutionContext inputRow, Integer[] outputToInputIndexes) {
        Morsel tempMorsel = new Morsel(new long[inputRow.numberOfRows() * inputRow.getLongsPerRow()], new AnyValue[inputRow.numberOfRows() * inputRow.getRefsPerRow()], inputRow.numberOfRows());
        MorselExecutionContext outputRow = MorselExecutionContext$.MODULE$.apply(tempMorsel, inputRow.getLongsPerRow(), inputRow.getRefsPerRow());
        while (outputRow.hasMoreRows()) {
            Integer fromIndex = outputToInputIndexes[outputRow.getCurrentRow()];
            inputRow.moveToRow(Predef$.MODULE$.Integer2int(fromIndex));
            outputRow.copyFrom(inputRow);
            outputRow.moveToNextRow();
        }
        inputRow.copyAllRowsFrom(outputRow);
    }

    public Comparator<MorselExecutionContext> createMorselComparator(ColumnOrder order) {
        Slot slot;
        block4: {
            Comparator<MorselExecutionContext> comparator;
            block3: {
                block2: {
                    slot = order.slot();
                    if (!(slot instanceof LongSlot)) break block2;
                    LongSlot longSlot = (LongSlot)slot;
                    int offset = longSlot.offset();
                    comparator = new Comparator<MorselExecutionContext>(order, offset){
                        private final ColumnOrder order$1;
                        private final int offset$3;

                        public int compare(MorselExecutionContext m1, MorselExecutionContext m2) {
                            long aVal = m1.getLongAt(this.offset$3);
                            long bVal = m2.getLongAt(this.offset$3);
                            return this.order$1.compareLongs(aVal, bVal);
                        }
                        {
                            this.order$1 = order$1;
                            this.offset$3 = offset$3;
                        }
                    };
                    break block3;
                }
                if (!(slot instanceof RefSlot)) break block4;
                RefSlot refSlot = (RefSlot)slot;
                int offset = refSlot.offset();
                comparator = new Comparator<MorselExecutionContext>(order, offset){
                    private final ColumnOrder order$1;
                    private final int offset$4;

                    public int compare(MorselExecutionContext m1, MorselExecutionContext m2) {
                        AnyValue aVal = m1.getRefAt(this.offset$4);
                        AnyValue bVal = m2.getRefAt(this.offset$4);
                        return this.order$1.compareValues(aVal, bVal);
                    }
                    {
                        this.order$1 = order$1;
                        this.offset$4 = offset$4;
                    }
                };
            }
            return comparator;
        }
        throw new MatchError((Object)slot);
    }

    private MorselSorting$() {
        MODULE$ = this;
    }
}

